﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using AForge.Video;
using AForge.Video.VFW;
namespace Avi
{
    /// <summary>
    /// AVI files writing using Video for Windows interface.
    /// </summary>
    /// 
    /// <remarks><para>The class allows to write AVI files using Video for Windows API.</para>
    /// 
    /// <para>Sample usage:</para>
    /// <code>
    /// // instantiate AVI writer, use WMV3 codec
    /// AVIWriter writer = new AVIWriter( "wmv3" );
    /// // create new AVI file and open it
    /// writer.Open( "test.avi", 320, 240 );
    /// // create frame image
    /// Bitmap image = new Bitmap( 320, 240 );
    /// 
    /// for ( int i = 0; i &lt; 240; i++ )
    /// {
    ///     // update image
    ///     image.SetPixel( i, i, Color.Red );
    ///     // add the image as a new frame of video file
    ///     writer.AddFrame( image );
    /// }
    /// writer.Close( );
    /// </code>
    /// </remarks>
    /// 
    public abstract class AviInterface:IDisposable {
        protected AviFile file;

        protected object sync = new object();

        ~AviInterface() {
            Dispose(false);
        }

        //public AviInterface() {
        //    // Win32.AVIFileInit();
        //}

        protected virtual void Dispose(bool disposing) {
            if(disposing) {
                // dispose managed resources
            }
            // закрыть текущий файл AVI если таковые открыты и закрыть AVI библиотеку
            Close();
            //  Win32.AVIFileExit();
        }

        public void Close() {
            lock(sync) {
                if (file != null)
                {
                    file.Close();
                    file = null;
                }
            }
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        public void Create(string fileName)
        {
            // Закрыть предыдущие файлы
            Close();

            // Проверяет, высота и ширина должны быть кратны 2

            lock (sync)
            {
                // Создаем новый файл
                file = AviFile.CreateAviFile(fileName);
                if (file == null)
                    throw new System.IO.IOException("Failed opening the specified file.");
            }
        }


    }

    public class MyAVIWriter:AviInterface {

        public MyAVIWriter(string fileName): base()
        {
            
        }

        public VideoStreamWrite AddVideoStream(int width, int height, int framerate, string codec = "DIB ", int quality = -1) {
            if(((width & 1) != 0) || ((height & 1) != 0))
                throw new ArgumentException("Video file resolution must be a multiple of two.");

            lock(sync) {
                // Создаем новый файл
                if(file == null)
                    throw new System.IO.IOException("Failed opening the specified file.");
                return file.AddVideoStream(width, height, framerate, codec, quality);
             }
        }

        public AudioStreamWrite AddAudioStream() {
           lock(sync) {
                // Создаем новый файл
                if(file == null) {
                    throw new System.IO.IOException("Failed opening the specified file.");
                }
                return file.AddAudioStream();
        
            }

        }

        //public void AddFrame(int numcam, Bitmap frameImage) {
        //    lock(sync) {
        //        file.AddFrame(numcam, frameImage);
        //    }
        //}
        //public void AddSample(int numcam, byte[] buffer, int count) {
        //    lock (sync)
        //    {
        //        file.AddSample(numcam, buffer, count);
        //    }
        //}
  
    }
}


/*
 *         x              y 








*/